<?php 
defined('BASEPATH') or exit('No direct script access allowed');

class Transaksi extends CI_Controller
{

	public function __construct(){
		parent::__construct();
		if(!$this->session->has_userdata('is_user_login'))
		{
			redirect('auth/login');
		}
	}
	
	function index($page=1)
    {
		$data['title'] = 'Transaksi';
		$us_id = $this->session->userdata('user_id');
		$this->load->helper('form');
		$this->db->select('a.*');	
		$this->db->where('a.us_id',$us_id);	
		if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.tr_no_hp', $this->input->get('cari'));
			$this->db->or_like('a.tr_id_plgn', $this->input->get('cari'));
			$this->db->or_like('a.tr_id', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tr_tanggal BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$produk);	
				}
				if ($this->input->get('status')) {
					if ($this->input->get('status') == 'refund') {
						$this->db->where('tr_status_pembayaran','refund');
					}elseif ($this->input->get('status') == 'sukses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','sukses');
					}elseif ($this->input->get('status') == 'proses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','-');
					}
				}
		}		
        $total = $this->db->count_all_results('transaksi a');
        $start = pagination_start($page);
        if ($total) {
			$this->db->select('a.*');		
			if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.tr_no_hp', $this->input->get('cari'));
			$this->db->or_like('a.tr_id_plgn', $this->input->get('cari'));
			$this->db->or_like('a.tr_id', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tr_tanggal BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$produk);	
				}
				if ($this->input->get('status')) {
					if ($this->input->get('status') == 'refund') {
						$this->db->where('tr_status_pembayaran','refund');
					}elseif ($this->input->get('status') == 'sukses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','sukses');
					}elseif ($this->input->get('status') == 'proses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','-');
					}
				}
			}
			$this->db->where('a.us_id',$us_id);	
			$this->db->order_by('a.tr_id', 'desc');
			if ($this->input->get('act') == 'download') {
				if ((@$end_date-@$start_date) > 2678400) {
					$this->session->set_flashdata('warning', 'Maximum hanya 1 Bulan');
					redirect('transaksi');
				}elseif ((@$start_date) == 0) {
					$this->session->set_flashdata('warning', 'Tanggal Harus diisi');
					redirect('transaksi');
				}
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('transaksi a')->result();
		
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		$data['title'] = 'Transaksi';
		$data['produk'] = $this->db->query("select op_produk from transaksi where us_id='".$us_id."' group by op_produk  order by op_produk")->result(); 
		$data['periode'] = $this->input->get('start').' - '.$this->input->get('end');
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['exp_time'] = $exp_time;
		$data['breadcumb'] = 'Transaksi';
		if (@$this->input->get('act') == 'download') {
			$this->report($trx);
		}else{
			$data['view'] = 'history/transaksi';
			$this->load->view('layout', $data);
		}
		
		
	}
	function view($id=1,$url="")
    {
		$data['title'] = 'Transaksi #'.$id;
		$us_id = $this->session->userdata('user_id');
		$uri = str_replace("/transaksi","",base64_decode($url));
		$this->db->select('a.*');	
		$this->db->where('a.tr_id',$id);	
		$this->db->where('a.us_id',$us_id);	
		//$total = $this->db->count_all_results('transaksi a');
        $trx = $this->db->get('transaksi a')->row();	
		$data['id'] = $id;
		$data['opsi'] = json_decode($trx->tr_opsi);
	//	$data['total'] = $total;
		$data['url'] = $uri;
		$data['uri'] = $url;
		$data['row'] = $trx;
		$data['view'] = 'history/view';
		$this->load->view('layout', $data);		
		
	}
	function cetak($id,$url="")
    {
		$data['title'] = 'Transaksi #'.$id;
		$us_id = $this->session->userdata('user_id');
		
		$this->db->where('tr_id',$id);
		$this->db->where('us_id',$us_id);	
		$row = $this->db->get('transaksi')->row();
		
		if ($row->tr_id =='') {
			$this->session->set_flashdata('error', 'Transaksi tidak ditemukan');
			redirect('transaksi/view/'.$id);
		}else{
			$harga = 0;
			if($this->input->post('biaya_admin')) {
				$harga = $row->tr_harga+$this->input->post('biaya_admin');
				
			}else{
				$harga = $row->tr_harga;
			}
			$opsi = json_decode($row->tr_opsi);
			$data = explode("/",$opsi->sn);
			$sn = @$data[0];
			$nama = @$data[1];
			$daya = @$data[2].'/'.@$data[3];
			$kwh = @$data[4];
			$params['id'] = $id;
			$params['url'] = $url;
			$params['sn'] = $sn;
			$params['nama'] = $nama;
			$params['daya'] = $daya;
			$params['kwh'] = $kwh;
			$params['row'] = $row;
			$params['harga_jual'] = $harga;
			$params['terbilang'] = $this->terbilang($harga);
			$params['reff'] = $opsi->sn;
			$params['jenis'] =  $this->input->post('jenis');
			//$params['jenis'] =  'M58';
			$this->load->view('struk/cetak', $params);
		}
	}
	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
 
	 function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim(($this->penyebut($nilai)));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		 return $hasil;
	 }
	private function report($trx) {
		$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Laporan Transaksi '.$this->input->get('start').' - '.$this->input->get('end'));
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:H2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'Tanggal')
                                        ->setCellValue('B2', 'Provider')
                                        ->setCellValue('C2', 'Voucher')
                                        ->setCellValue('D2', 'No HP')
                                        ->setCellValue('E2', 'Harga Beli')
                                        ->setCellValue('F2', 'Harga Jual')
                                        ->setCellValue('G2', 'Harga Laba')
                                        ->setCellValue('H2', 'Status');
		
			$i = 3;
			$ttl_laba = 0;
			$ttl_hb = 0;
			$ttl_hj = 0;
			foreach ( $trx as $row) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', format_tanggal($row->tr_tanggal))
				->setCellValue('B'.$i.'', $row->op_nama)
				->setCellValue('C'.$i.'', $row->vo_nominal)
				->setCellValue('D'.$i.'', $row->tr_no_hp)
				->setCellValue('E'.$i.'', format_uang2($row->tr_harga))
				->setCellValue('F'.$i.'', ($row->tr_status == 'sukses' ? format_uang2($row->tr_harga+$row->tr_income_user) : "0"))
				->setCellValue('G'.$i.'',  ($row->tr_status == 'sukses' ? format_uang2($row->tr_income_user) : "0"))
				->setCellValue('H'.$i.'', ucfirst($row->tr_status));
				if ($row->tr_status == 'sukses'){
					$ttl_laba = $ttl_laba+$row->tr_income_user;
					$ttl_hb = $ttl_hb+$row->tr_harga;
					$ttl_hj = $ttl_hj+$row->tr_income_user+$row->tr_harga;
				}
			$i++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':H'.$i.'')->getFont()->setBold(true);
			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('D'.$i.'', 'Total')
				->setCellValue('E'.$i.'', format_uang2($ttl_hb))
				->setCellValue('F'.$i.'', format_uang2($ttl_hj))
				->setCellValue('G'.$i.'', format_uang2($ttl_laba));
          
			 $objPHPExcel->getActiveSheet()->setTitle('Laporan_'.$this->input->get('start').' - '.$this->input->get('end').'');            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan_'.$this->input->get('start').' - '.$this->input->get('end').'.xls"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	
	
	
}
