<?php 
defined('BASEPATH') or exit('No direct script access allowed');

class Mutasi extends CI_Controller
{

	public function __construct(){
		parent::__construct();
		if(!$this->session->has_userdata('is_user_login'))
		{
			redirect('auth/login');
		}
	}
	
	function index($page=1)
    {
		$data['title'] = 'Mutasi Saldo';
		$us_id = $this->session->userdata('user_id');
		$this->load->helper('form');
		$this->db->select('a.*');	
		$this->db->where('a.us_id',$us_id);	
		if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') ) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			
			
				$this->db->like('a.info', $this->input->get('cari'));
			
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tanggal BETWEEN $start_date AND $end_date");
				}
				
		}		
        $total = $this->db->count_all_results('balance_history a');
        $start = pagination_start($page);
        if ($total) {
			$this->db->select('a.*');		
			if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
				
				$this->db->like('a.info', $this->input->get('cari'));
			
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tanggal BETWEEN $start_date AND $end_date");
				}
			}
			$this->db->where('a.us_id',$us_id);	
			$this->db->order_by('a.id', 'desc');
			if ($this->input->get('act') == 'download') {
				if ((@$end_date-@$start_date) > 2678400) {
					echo "Maximum hanya 1 Hari"; die();
				}elseif ((@$start_date) == 0) {
					echo "Tanggal harus diisi"; die();
				}
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('balance_history a')->result();
		
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		
		$data['periode'] = $this->input->get('start').' - '.$this->input->get('end');
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['exp_time'] = $exp_time;
		$data['breadcumb'] = 'Mutasi Saldo';
		if (@$this->input->get('act') == 'download') {
			$this->report($trx);
		}else{
			$data['view'] = 'mutasi/index';
			$this->load->view('layout', $data);
		}
		
		
	}
	private function report($trx) {
		$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Mutasi Saldo '.$this->input->get('start').' - '.$this->input->get('end'));
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:D2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'Tanggal')
                                        ->setCellValue('B2', 'Keterangan')
                                        ->setCellValue('C2', 'Kredit')
                                        ->setCellValue('D2', 'Debet')
                                        ->setCellValue('E2', 'Saldo Akhir');
		
			$i = 3;
			
			foreach ( $trx as $res) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', format_tanggal($res->tanggal))
				->setCellValue('B'.$i.'', $res->info)
				->setCellValue('C'.$i.'', format_uang($res->kredit))
				->setCellValue('D'.$i.'', format_uang($res->debet))
				->setCellValue('E'.$i.'', $res->saldo_akhir ? format_uang($res->saldo_akhir) : '');
			$i++;
			}
          
			 $objPHPExcel->getActiveSheet()->setTitle('Mutasi_'.$this->input->get('start').' - '.$this->input->get('end').'');            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Mutasi_'.$this->input->get('start').' - '.$this->input->get('end').'.xls"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	
	
	
}
