<?php 
defined('BASEPATH') or exit('No direct script access allowed');

class Harga extends CI_Controller
{

	public function __construct(){
		parent::__construct();
		if(!$this->session->has_userdata('is_user_login'))
		{
			redirect('auth/login');
		}
	}
	
	function index($page=1)
    {
		$data['title'] = 'Daftar Harga';
		
		$us_id = $this->session->userdata('user_id');
		$this->load->helper('form');
		$this->db->select('a.*');	
		$this->db->where('a.vo_status','1');	
		if ($this->input->get('cari') OR $this->input->get('produk')) {
				$this->db->like('a.vo_nominal', $this->input->get('cari'));
			
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$this->input->get('produk'));	
				}
				
		}		
        $total = $this->db->count_all_results('voucher a');
        $start = pagination_start($page);
		$markup = 0;
        if ($total) {
			$this->db->select('a.*');
			if ($this->input->get('markup')) {	
				$markup = $this->input->get('markup');
			}else{
				$markup = 0;
			}				
			if ($this->input->get('cari') OR $this->input->get('produk')) {
	
				$this->db->like('a.vo_nominal', $this->input->get('cari'));
			
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$this->input->get('produk'));	
				}
			}
			$this->db->where('a.vo_status','1');	
			$this->db->order_by('a.vo_harga', 'asc');
			
			$this->db->order_by('a.vo_nominal', 'asc');
			if ($this->input->get('act') == 'download') {
				
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('voucher a')->result();
			
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		
		$data['produk'] = $this->db->query("select a.op_produk from voucher a where a.vo_status='1'  group by a.op_produk  order by op_produk")->result(); 
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['markup'] = $markup;
		
		$data['breadcumb'] = 'Harga';
		if (@$this->input->get('act') == 'download') {
			$this->report($trx);
		}else{
			$data['view'] = 'harga/index';
			$this->load->view('layout', $data);
		}
		
		
	}
	
	private function report($trx) {
			$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Daftar Harga');
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:E2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'Produk')
                                        ->setCellValue('B2', 'Kode')
                                        ->setCellValue('C2', 'Keterangan')
                                        ->setCellValue('D2', 'Harga Umum')
                                        ->setCellValue('E2', 'Harga Reseller');
		
			$i = 3;
			$markup = 0;
			if ($this->input->get('markup')) {	
				$markup = $this->input->get('markup');
			}else{
				$markup = 0;
			}	
			foreach ( $trx as $res) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', str_replace("_"," ",strtoupper($res->op_produk)))
				->setCellValue('B'.$i.'', $res->vo_kode_trx)
				->setCellValue('C'.$i.'', $res->vo_nominal)
				->setCellValue('D'.$i.'', format_uang($res->vo_harga+$markup))
				->setCellValue('E'.$i.'', format_uang($res->vo_harga_reseller+$markup));
			$i++;
			}
          
			 $objPHPExcel->getActiveSheet()->setTitle('Harga');            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Daftar_Harga_'.date('d M Y').'.xls"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	
	
	
}
