<?php 
defined('BASEPATH') or exit('No direct script access allowed');

class Deposit extends CI_Controller
{

	public function __construct(){
		parent::__construct();
		if(!$this->session->has_userdata('is_user_login'))
		{
			redirect('auth/login');
		}
	}
	
	function index($page=1)
    {
		$data['title'] = 'Riwayat Deposit';
		$us_id = $this->session->userdata('user_id');
		$this->load->helper('form');
		$this->db->select('a.*');	
		$this->db->where('a.us_id',$us_id);	
		if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') ) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			
			
				$this->db->like('a.de_amount', $this->input->get('cari'));
			
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("de_tanggal BETWEEN $start_date AND $end_date");
				}
				
		}		
        $total = $this->db->count_all_results('deposit a');
        $start = pagination_start($page);
        if ($total) {
			$this->db->select('a.*');		
			if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
				
				$this->db->like('a.de_amount', $this->input->get('cari'));
			
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("de_tanggal BETWEEN $start_date AND $end_date");
				}
			}
			$this->db->where('a.us_id',$us_id);	
			$this->db->order_by('a.de_id', 'desc');
			if ($this->input->get('act') == 'download') {
				if ((@$end_date-@$start_date) > 2678400) {
					echo "Maximum hanya 1 Hari"; die();
				}elseif ((@$start_date) == 0) {
					echo "Tanggal harus diisi"; die();
				}
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('deposit a')->result();
		
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		
		$data['periode'] = $this->input->get('start').' - '.$this->input->get('end');
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['exp_time'] = $exp_time;
		$data['breadcumb'] = 'Deposit';
		if (@$this->input->get('act') == 'download') {
			$this->report($trx);
		}else{
			$data['view'] = 'deposit/index';
			$this->load->view('layout', $data);
		}
		
		
	}
	function view($id=1,$url="")
    {
		$data['title'] = 'Deposit #'.$id;
		$us_id = $this->session->userdata('user_id');
		$uri = str_replace("/deposit","",base64_decode($url));
		$this->db->select('a.*,b.keterangan');	
		$this->db->join('mutasi b', 'a.de_id=b.dep_id', 'left');
		$this->db->where('a.de_id',$id);	
		$this->db->where('a.us_id',$us_id);	
        $trx = $this->db->get('deposit a')->row();	
		$data['id'] = $id;
		$data['url'] = $uri;
		$data['uri'] = $url;
		$data['row'] = $trx;
		$data['view'] = 'deposit/view';
		$this->load->view('layout', $data);		
		
	}
	private function report($trx) {
		$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Riwayat Deposit '.$this->input->get('start').' - '.$this->input->get('end'));
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:D2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'Tanggal')
                                        ->setCellValue('B2', 'Jumlah')
                                        ->setCellValue('C2', 'Pembayaran')
                                        ->setCellValue('D2', 'Status');
		
			$i = 3;
			
			foreach ( $trx as $res) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', format_tanggal($res->de_tanggal))
				->setCellValue('B'.$i.'', format_uang($res->de_amount))
				->setCellValue('C'.$i.'',  payment($res->de_payment))
				->setCellValue('D'.$i.'', $res->de_status);
			$i++;
			}
          
			 $objPHPExcel->getActiveSheet()->setTitle('Deposit_'.$this->input->get('start').' - '.$this->input->get('end').'');            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Deposit_'.$this->input->get('start').' - '.$this->input->get('end').'.xls"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	
	
	
}
