<?php 
defined('BASEPATH') or exit('No direct script access allowed');

class Cetak_struk extends CI_Controller
{

	public function __construct(){
		parent::__construct();
		$this->load->model('user/user_model', 'user_model');
	}
	
	function index()
    {
		$this->load->helper('form');
     
		$data['user'] = $this->user_model->get_user_detail();
		$data['title'] = 'Cetak Struk';
		$data['view'] = 'struk/index';
		$this->load->view('layout', $data);
	}
	
	function cetak()
    {
		
		
		$this->db->or_group_start();
		$this->db->where('tr_id',$this->input->post('trid'));
		$this->db->where("tr_no_hp", $this->input->post('nomor'));
		$this->db->group_end();
		
		$this->db->or_group_start();
		$this->db->where('tr_id',$this->input->post('trid'));
		$this->db->where("tr_id_plgn", $this->input->post('nomor'));
		$this->db->group_end();
		$row = $this->db->get('transaksi')->row();
		
		if ($row->tr_id =='') {
			$this->session->set_flashdata('error', 'Transaksi tidak ditemukan');
			redirect('struk');
		}else{
			if($this->input->post('harga') == 0) {
				$harga = $row->tr_harga;
			}else{
				$harga = $this->input->post('harga');
			}
			$opsi = json_decode($row->tr_opsi);
			$data = explode("/",$opsi->sn);
			$sn = $data[0];
			$nama = $data[1];
			$daya = $data[2].'/'.$data[3];
			$kwh = $data[4];
			$params['sn'] = $sn;
			$params['nama'] = $nama;
			$params['daya'] = $daya;
			$params['kwh'] = $kwh;
			$params['row'] = $row;
			$params['harga_jual'] = $harga;
			$params['terbilang'] = $this->terbilang($harga);
			$params['reff'] = $opsi->sn;
			$params['jenis'] =  $this->input->post('jenis');
			$this->load->view('struk/cetak', $params);
		}
	}
	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
 
	 function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim(($this->penyebut($nilai)));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		 return $hasil;
	 }

	
}
