<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Auth extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->library('mailer');
		$this->load->model('auth_model', 'auth_model');
	}
	//-------------------------------------------------------------------------
	public function index(){
		// if($this->session->has_userdata('is_admin_login'))
		// {
			// redirect('admin/dashboard');
		// }
		if($this->session->has_userdata('is_user_login'))
		{
			redirect('dashboard');
		}
		else{
			redirect('auth/login');
		}
	}
	public function google()
    {
		$this->load->library('google');
		$google_data=$this->google->validate();
		
		$data = $this->db->get_where('users', array('us_email'=>$google_data['email']));
	
		if ($data->num_rows() > 0){
				$res = $data->row_array();
				$user_data = array(
							'user_id' => $res['us_id'],
							'email' => $res['us_email'],
							'name' => $res['us_name'],
							'rights' => $res['us_rights'],
							'is_user_login' => TRUE,
							//'is_admin_login' => TRUE
						);
						$this->session->set_userdata($user_data);
						redirect(base_url('dashboard'), 'refresh');
				$pesan = "Akun anda berhasil login melalui Google,\r\nAlamat IP : ".$this->get_client_ip()."\r\nBrowser : ".$_SERVER['HTTP_USER_AGENT']." ";
				
				sendEmail($google_data['email'], 'Login via Google Berhasil', $pesan, $file = '' , $cc = '');
                redirect('dashboard');
		}else{
			 $this->session->set_flashdata('error','Email kamu belum terdaftar.');
            redirect('auth/login');
		}
		
		
    }
	function get_client_ip() {
		$ipaddress = '';
		if (isset($_SERVER['HTTP_CLIENT_IP']))
			$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
		else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_X_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
		else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_FORWARDED'];
		else if(isset($_SERVER['REMOTE_ADDR']))
			$ipaddress = $_SERVER['REMOTE_ADDR'];
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	//-------------------------------------------------------------------------	
	public function login(){
		
		if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] ==
			1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] ==
			'https') {
			$protocol = 'https';
		} else {
			$protocol = 'http';
		}
		if ($protocol == 'http' && substr($_SERVER['REQUEST_URI'], 0, 12) !=
			'/sms-gateway') {
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
			exit();
		}
		$this->load->library('google');
		if($this->input->post('submit')){
			$this->form_validation->set_rules('email', 'Email', 'trim|required');
			$this->form_validation->set_rules('password', 'Password', 'trim|required');

			if ($this->form_validation->run() == FALSE) {
				$this->load->view('auth/login');
			}
			else {
				$data = array(
					'email' => $this->input->post('email'),
					'password' => $this->input->post('password')
				);
				$data = $this->security->xss_clean($data);
				$result = $this->auth_model->login($data);
				if($result){
					if($result['us_block'] == 1){
			    		$this->session->set_flashdata('warning', 'User anda terblokir, Silahkan hubungi CS!');
						redirect(base_url('auth/login'));
						exit;
			    	}
					
						$user_data = array(
							'user_id' => $result['us_id'],
							'name' => $result['us_name'],
							'email' => $result['us_email'],
							'rights' => $result['us_rights'],
							'is_user_login' => TRUE,
							//'is_admin_login' => TRUE
						);
						$this->session->set_userdata($user_data);
						redirect(base_url('dashboard'), 'refresh');
				
				}
				else{
					$data['msg'] = 'Email atau password anda tidak benar!';
					$this->load->view('auth/login', $data); 
				}
			}
		}
		else{
			$data['title'] = 'Login';
			$this->load->view('auth/login');
		}
	}
	public function login_sipp(){
		if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] ==
			1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] ==
			'https') {
			$protocol = 'https';
		} else {
			$protocol = 'http';
		}
		if ($protocol == 'http' && substr($_SERVER['REQUEST_URI'], 0, 12) !=
			'/sms-gateway') {
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
			exit();
		}
		if($this->input->post('submit')){
			$this->form_validation->set_rules('email', 'Email', 'trim|required');
			$this->form_validation->set_rules('password', 'Password', 'trim|required');

			if ($this->form_validation->run() == FALSE) {
				$this->load->view('auth/login_sipp');
			}
			else {
				$data = array(
					'email' => $this->input->post('email'),
					'password' => $this->input->post('password')
				);
				$data = $this->security->xss_clean($data);
				$result = $this->auth_model->login_sipp($data);
				if($result){
					if($result['us_block'] == 1){
			    		$this->session->set_flashdata('warning', 'User anda terblokir, Silahkan hubungi CS!');
						redirect(base_url('auth/login_sipp'));
						exit;
			    	}
					
						$user_data = array(
							'user_id' => $result['us_id'],
							'name' => $result['us_name'],
							'rights' => $result['us_rights'],
							'is_user_login' => TRUE,
							//'is_admin_login' => TRUE
						);
						$this->session->set_userdata($user_data);
						redirect(base_url('dashboard'), 'refresh');
				
				}
				else{
					$data['msg'] = 'Email atau password anda tidak benar!';
					$this->load->view('auth/login_sipp', $data); 
				}
			}
		}
		else{
			$data['title'] = 'Login';
			$this->load->view('auth/login_sipp');
		}
	}	

	//-------------------------------------------------------------------------
	public function register(){
		die();
		if($this->input->post('submit')){
			$this->form_validation->set_rules('username', 'Username', 'trim|required|is_unique[ci_users.username]');
			$this->form_validation->set_rules('firstname', 'Firstname', 'trim|required');
			$this->form_validation->set_rules('lastname', 'Lastname', 'trim|required');
			$this->form_validation->set_rules('email', 'Email', 'trim|valid_email|is_unique[ci_users.email]|required');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');
			$this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'trim|required|matches[password]');

			if ($this->form_validation->run() == FALSE) {
				$data['title'] = 'Create an Account';
				$this->load->view('auth/register', $data);
			}
			else{
				$data = array(
					'firstname' => $this->input->post('firstname'),
					'lastname' => $this->input->post('lastname'),
					'email' => $this->input->post('email'),
					'password' =>  password_hash($this->input->post('password'), PASSWORD_BCRYPT),
					'is_active' => 1,
					'is_verify' => 0,
					'token' => md5(rand(0,1000)),    
					'last_ip' => '',
					'created_at' => date('Y-m-d : h:m:s'),
					'updated_at' => date('Y-m-d : h:m:s'),
				);
				$data = $this->security->xss_clean($data);
				$result = $this->auth_model->register($data);
				if($result){
					//sending welcome email to user
					$name = $data['firstname'].' '.$data['lastname'];
					$email_verification_link = base_url('auth/verify/').'/'.$data['token'];
					$body = $this->mailer->Tpl_Registration($name, $email_verification_link);
					$this->load->helper('email_helper');
					$to = $data['email'];
					$subject = 'Activate your account';
					$message =  $body ;
					$email = sendEmail($to, $subject, $message, $file = '' , $cc = '');
					$email = true;
					if($email){
						$this->session->set_flashdata('success', 'Your Account has been made, please verify it by clicking the activation link that has been send to your email.');	
						redirect(base_url('auth/login'));
					}	
					else{
						echo 'Email Error';
					}
				}
			}
		}
		else{
			$data['title'] = 'Create an Account';
			$this->load->view('auth/register', $data);
		}
	}

	//----------------------------------------------------------	
	public function verify(){
		$verification_id = $this->uri->segment(3);
		$result = $this->auth_model->email_verification($verification_id);
		if($result){
			$this->session->set_flashdata('success', 'Your email has been verified, you can now login.');	
			redirect(base_url('auth/login'));
		}
		else{
			$this->session->set_flashdata('success', 'The url is either invalid or you already have activated your account.');	
			redirect(base_url('auth/login'));
		}	
	}

	//--------------------------------------------------		
	public function forgot_password(){
		if($this->input->post('submit')){
			//checking server side validation
			$this->form_validation->set_rules('email', 'Email', 'valid_email|trim|required');
			if ($this->form_validation->run() === FALSE) {
				$this->load->view('auth/forget_password');
				return;
			}
			$email = $this->input->post('email');
			$response = $this->auth_model->check_user_mail($email);
			if($response){
				$rand_no = rand(0,1000);
				$pwd_reset_code = md5($rand_no.$response['id']);
				$this->auth_model->update_reset_code($pwd_reset_code, $response['id']);
				// --- sending email
				$name = $response['firstname'].' '.$response['lastname'];
				$email = $response['email'];
				$reset_link = base_url('auth/reset-password/'.$pwd_reset_code);
				$body = $this->mailer->Tpl_PwdResetLink($name,$reset_link);

				$this->load->helper('email_helper');
				$to = $email;
				$subject = 'Reset your password';
				$message =  $body ;
				$email = sendEmail($to, $subject, $message, $file = '' , $cc = '');
				if($email){
					$this->session->set_flashdata('success', 'We have sent instructions for resetting your password to your email');

					redirect(base_url('auth/forgot-password'));
				}
				else{
					$this->session->set_flashdata('error', 'There is the problem on your email');
					redirect(base_url('auth/forgot-password'));
				}
			}
			else{
				$this->session->set_flashdata('error', 'The Email that you provided are invalid');
				redirect(base_url('auth/forgot-password'));
			}
		}
		else{
			$data['title'] = 'Forget Password';
			$this->load->view('auth/forget_password',$data);	
		}
	}

	//--------------------------------------------------		
	public function reset_password($id=0){
		// check the activation code in database
		if($this->input->post('submit')){
			$this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');
			$this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'trim|required|matches[password]');

			if ($this->form_validation->run() == FALSE) {
				$result = false;
				$data['reset_code'] = $id;
				$data['title'] = 'Reseat Password';
				$this->load->view('auth/reset_password',$data);
			}   
			else{
				$new_password = password_hash($this->input->post('password'), PASSWORD_BCRYPT);
				$this->auth_model->reset_password($id, $new_password);
				$this->session->set_flashdata('success','New password has been Updated successfully.Please login below');
				redirect(base_url('auth/login'));
			}
		}
		else{
			$result = $this->auth_model->check_password_reset_code($id);
			if($result){
				$data['reset_code'] = $id;
				$data['title'] = 'Reseat Password';
				$this->load->view('auth/reset_password',$data);
			}
			else{
				$this->session->set_flashdata('error','Password Reset Code is either invalid or expired.');
				redirect(base_url('auth/forgot-password'));
			}
		}
	}

	//-------------------------------------------------------------------------
	public function profile(){
		if($this->input->post('submit')){
			$data = array(
				'username' => $this->input->post('username'),
				'firstname' => $this->input->post('firstname'),
				'lastname' => $this->input->post('lastname'),
				'email' => $this->input->post('email'),
				'mobile_no' => $this->input->post('mobile_no'),
				'updated_at' => date('Y-m-d : h:m:s'),
			);
			$data = $this->security->xss_clean($data);
			$result = $this->auth_model->update_admin($data);
			if($result){
				$this->session->set_flashdata('msg', 'Profile has been Updated Successfully!');
				redirect(base_url('auth/profile'), 'refresh');
			}
		}
		else{
			$data['admin'] = $this->auth_model->get_admin_detail();
			$data['title'] = 'User Profile';
			$data['view'] = 'auth/profile';
			$this->load->view('layout', $data);
		}
	}
	//-------------------------------------------------------------------------
	public function change_pwd(){
		$id = $this->session->userdata('admin_id');
		if($this->input->post('submit')){
			$this->form_validation->set_rules('password', 'Password', 'trim|required');
			$this->form_validation->set_rules('confirm_pwd', 'Confirm Password', 'trim|required|matches[password]');
			if ($this->form_validation->run() == FALSE) {
				$data['admin'] = $this->auth_model->get_admin_detail();
				$data['view'] = 'auth/profile';
				$this->load->view('layout', $data);
			}
			else{
				$data = array(
					'password' => password_hash($this->input->post('password'), PASSWORD_BCRYPT)
				);
				$data = $this->security->xss_clean($data);
				$result = $this->auth_model->change_pwd($data, $id);
				if($result){
					$this->session->set_flashdata('msg', 'Password has been changed successfully!');
					redirect(base_url('auth/profile'));
				}
			}
		}
		else{
			$data['title'] = 'Change Password';
			$data['view'] = 'auth/change_pwd';
			$this->load->view('layout', $data);
		}
	}
	//-------------------------------------------------------------------------
	public function logout(){
		$this->session->sess_destroy();
		redirect(base_url('auth/login'), 'refresh');
	}

}  // end class


?>