<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Administrasi extends UR_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('rights') <> '6'){
			redirect('dashboard');
		}
	}
	//-------------------------------------------------------------------------
	public function index(){
			
			$id = $this->session->userdata('user_id');
			$query = $this->db->get_where('orderkuo_db.users', array('us_id' => $id));
			$result = $query->row();
			$this->db->where('a.us_id',$id);	
			$this->db->order_by('a.tr_id', 'desc');
			$this->db->limit(10);
            $total_trx = $this->db->count_all_results('transaksi a');
			
			$this->db->where('a.us_id',$id);	
			$this->db->order_by('a.tr_id', 'desc');
			$this->db->limit(10);
			
            $trx = $this->db->get('transaksi a')->result();
			$exp_time = time() - 3600 * 2;
			$tanggal = strtotime(date('Y-m-01'));
			$data['trx_sukses'] = $this->db->query("select count(*) as trx from transaksi where tr_status='sukses' and us_id='".$id."' and tr_tanggal > ".$tanggal."")->row()->trx;
			$data['trx_proses'] = $this->db->query("select count(*) as trx from transaksi where (tr_status='dalam_proses' or tr_status='-') and us_id='".$id."' and tr_tanggal > ".$tanggal."")->row()->trx;
			$data['trx_gagal'] = $this->db->query("select count(*) as trx from transaksi where tr_status='gagal' and us_id='".$id."' and tr_tanggal > ".$tanggal."")->row()->trx;
			$data['downline'] = $this->db->query("select count(*) as downline from orderkuo_db.users where us_upline='".$id."'")->row()->downline;
			$data['exp_time'] = $total_trx;
			$data['total_trx'] = $total_trx;
			$data['row'] = $result;
			$data['last_update'] = $this->db->get_where('tbinfo', array('type' => 'cron_end'))->row()->val;
			$data['trx'] = $trx;
			$data['title'] = 'Profile';
			$data['breadcumb'] = 'Utama';
			$data['view'] = 'administrasi/index';
			$this->load->view('layout', $data);
		
	}
	function transaksi($page=1)
    {
		$data['title'] = 'Transaksi';
		$us_id = $this->session->userdata('user_id');
		$this->load->helper('form');
		$this->db->select('a.*');	
		//$this->db->where('a.us_id',$us_id);	
		if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.tr_no_hp', $this->input->get('cari'));
			$this->db->or_like('a.tr_id_plgn', $this->input->get('cari'));
			$this->db->or_like('a.tr_id', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tr_tanggal BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$produk);	
				}
				if ($this->input->get('status')) {
					if ($this->input->get('status') == 'refund') {
						$this->db->where('tr_status_pembayaran','refund');
					}elseif ($this->input->get('status') == 'sukses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','sukses');
					}elseif ($this->input->get('status') == 'proses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','-');
					}
				}
				$this->db->where('tr_harga >',100);
				$this->db->where('tr_status','sukses');		
				$total = $this->db->count_all_results('transaksi a');
		}else{
			
			$total = 100000;
		}		
		
        $start = pagination_start($page);
        if ($total) {
			$this->db->select('a.*');		
			if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.tr_no_hp', $this->input->get('cari'));
			$this->db->or_like('a.tr_id_plgn', $this->input->get('cari'));
			$this->db->or_like('a.tr_id', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tr_tanggal BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.op_produk',$produk);	
				}
				if ($this->input->get('status')) {
					if ($this->input->get('status') == 'refund') {
						$this->db->where('tr_status_pembayaran','refund');
					}elseif ($this->input->get('status') == 'sukses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','sukses');
					}elseif ($this->input->get('status') == 'proses') {
						$this->db->where('tr_status_pembayaran','sukses');
						$this->db->where('tr_status','-');
					}
				}
			}else{
				$this->db->where("FROM_UNIXTIME(tr_tanggal,'%Y-%m-%d %H:%i:%s') BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()");
			}
			//$this->db->where('a.us_id',$us_id);	
			$this->db->where('tr_status','sukses');
			$this->db->where('tr_harga >',100);
			$this->db->order_by('a.tr_id', 'desc');
			if ($this->input->get('act') == 'download') {
				if ((@$end_date-@$start_date) > 2678400) {
					$this->session->set_flashdata('warning', 'Maximum hanya 1 Bulan');
					redirect('transaksi');
				}elseif ((@$start_date) == 0) {
					$this->session->set_flashdata('warning', 'Tanggal Harus diisi');
					redirect('transaksi');
				}
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('transaksi a')->result();
			
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		$data['title'] = 'Transaksi';
		$data['produk'] = $this->db->query("select op_produk from transaksi group by op_produk  order by op_produk")->result(); 
		$data['periode'] = $this->input->get('start').' - '.$this->input->get('end');
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['exp_time'] = $exp_time;
		$data['breadcumb'] = 'Transaksi';
		if (@$this->input->get('act') == 'download') {
			$this->report_trx($trx);
		}else{
			$data['view'] = 'administrasi/transaksi';
			$this->load->view('layout', $data);
		}
		
		
	}
	public function bank_upload()
    {
		//$config["upload_path"] = APPPATH . "cache/";
		//$config["upload_path"] = APPPATH . "logs/";
		$config["upload_path"] = "./uploads/";
        $config["allowed_types"] = "*";
		$new_name = $this->input->post('bank').'.txt';
		$config['file_name'] = $new_name;
        $config["overwrite"] = true;
        $config["max_size"] = 10000;
        $this->load->library("upload", $config);
        if( !$this->upload->do_upload("file") ) 
        {
			// print_r($this->upload->display_errors());die();
            // $this->session->set_flashdata("error", $this->upload->display_errors());
            redirect("administrasi/bank_tools?success=false&msg=".urlencode($this->upload->display_errors())."");
        }
        else
        {
			$result = $this->upload->data();
			if ($this->input->post('bank') =='bank_mandiri'){
				$ret = $this->mandiri_upload();
			}
			if ($this->input->post('bank') =='bank_bca'){
				$ret = $this->bca_upload();
			}
			if ($this->input->post('bank') =='bank_bri'){
				$ret = $this->bri_upload();
			}
			if ($this->input->post('bank') =='bank_bni'){
				$ret = $this->bni_upload();
			}
			redirect("administrasi/bank_tools?success=true&msg=".urlencode(''.$ret.' Data')."");
		}
      
    }
	public function mandiri_upload()
    {
		$data = file_get_contents('uploads/bank_mandiri.txt');
		$data = explode("\n",$data);
		$total = count($data) - 1;
		$ttl = 0;
		for ($x = 0; $x <= $total; $x++) {
			
			  $row = explode(";",$data[$x]);
			  
			  $no_rek = trim($row[0]);
			  if ($no_rek == '1420080004285') {
				  $currency = trim($row[1]);
				  $tanggal = substr(trim($row[2]),6,4).'-'.substr(trim($row[2]),3,2).'-'.substr(trim($row[2]),0,2);
				  $keterangan = trim($row[3]).' '.trim($row[4]);
				  if (strpos(trim($row[5]), 'DR') !== false) {
						$debet = str_replace('DR','',trim($row[5]));
						$kredit = 0;
					}else{
						$debet = 0;
						$kredit = trim($row[5]);
					}
					$saldo = trim($row[6]);
					$hash = md5($tanggal.$debet.$kredit.$keterangan.$saldo);
					$this->db->where('bank','bank_mandiri');
					$this->db->where('hash',$hash);
					$cnt = $this->db->get('tblmutasi')->num_rows();
					if (!$cnt){
						$res = array (	
										'bank' => 'bank_mandiri',
										'no_rek' => $no_rek,
										'hash' => $hash,
										'debet' => $debet,
										'kredit' => $kredit,
										'saldo' => $saldo,
										'keterangan' => $keterangan,
										'tgl' => $tanggal,
										'tgl2' => strtotime($tanggal),
										'tanggal' =>time(),
										);
						if ($kredit <> ''){
							$this->db->insert('tblmutasi',$res);
							$ttl++;
						}
					}
				}
		}
		return $ttl;
	}
	public function bca_upload()
    {
		$data = file_get_contents('uploads/bank_bca.txt');
		$data = explode("\n",$data);
		//print_r($data);
		$no_rek = str_replace('No. rekening : ','', str_replace('"','',$data[2]));
		$total = count($data) - 1;
		$ttl = 0;
		for ($x = 7; $x <= $total; $x++) {
			
			  $row = explode('","',$data[$x]);
			  
			  if ($no_rek == '0501004285') {
				  //print_r($row);
				  $currency = trim($row[1]);
				  $rtgl = trim(str_replace('"','',$row[0]));
				  $tanggal = date('Y').'-'.substr($rtgl,3,2).'-'.substr($rtgl,0,2);
				  $keterangan = trim(str_replace('"','',$row[1]));
				  $rnominal = trim(str_replace('"','',$row[3]));
				  if (strpos($rnominal, 'DB') !== false) {
						$nl = explode(".",str_replace(',','',str_replace(' DB','',trim($rnominal))));
						$debet = $nl[0];
						$kredit = 0;
					}else{
						$nl = explode(".",str_replace(',','',str_replace(' CR','',trim($rnominal))));
						$debet = 0;
						$kredit = $nl[0];
					}
					$nls = explode(".",str_replace(',','',trim($row[4])));
					$saldo = $nls[0];
					$hash = md5($debet.$kredit.$keterangan.$saldo);
					$this->db->where('bank','bank_bca');
					$this->db->where('hash',$hash);
					$cnt = $this->db->get('tblmutasi')->num_rows();
					if (!$cnt){
						
						$res = array (	
										'bank' => 'bank_bca',
										'no_rek' => $no_rek,
										'hash' => $hash,
										'debet' => $debet,
										'kredit' => $kredit,
										'saldo' => $saldo,
										'keterangan' => $keterangan,
										'tgl' => $tanggal,
										'tgl2' => strtotime($tanggal),
										'tanggal' =>time(),
										);
									//	print_r($res);
						if ($kredit <> ''){
							$this->db->insert('tblmutasi',$res);
							$ttl++;
						}
					}
				}
		}
		return $ttl;
	}
	
	public function bri_upload()
    {
		$data = file_get_contents('uploads/bank_bri.txt');
		$data = explode("\n",$data);
		//print_r($data);
		$nno_rek = explode(",", str_replace('-','',$data[3]));
		$no_rek = trim($nno_rek[1]); 
		$total = count($data) - 6;
		$ttl = 0;
		for ($x = 9; $x <= $total; $x++) {
			
			  $row = explode(',',$data[$x]);
			  
			  if ($no_rek == '0000005501002452301') {
				  //print_r($row);
				  $rtgl = explode("/",trim($row[0]));
				  $tanggal = '20'.$rtgl[2].'-'.str_pad($rtgl[1],2,"0",STR_PAD_LEFT).'-'.str_pad($rtgl[0],2,"0",STR_PAD_LEFT);
				  $keterangan = trim(str_replace('"','',$row[2]));
				  $rnominal = trim(str_replace('"','',$row[3]));
				 
						$nld = explode(".",trim($row[4]));
						$nlk = explode(".",trim($row[5]));
						$nls = explode(".",trim($row[6]));
						$debet = $nld[0];
						$kredit = $nlk[0];
						$saldo = $nls[0];
					$hash = md5($tanggal.$debet.$kredit.$keterangan);
					$this->db->where('bank','bank_bri');
					$this->db->where('hash',$hash);
					$cnt = $this->db->get('tblmutasi')->num_rows();
					if (!$cnt){
						$res = array (	
										'bank' => 'bank_bri',
										'no_rek' => $no_rek,
										'hash' => $hash,
										'debet' => $debet,
										'kredit' => $kredit,
										'saldo' => $saldo,
										'keterangan' => $keterangan,
										'tgl' => $tanggal,
										'tgl2' => strtotime($tanggal),
										'tanggal' =>time(),
										);
									//	print_r($res);
						if ($kredit <> ''){
							$this->db->insert('tblmutasi',$res);
						
							$ttl++;
						}
					}
				}
		}
		
		return $ttl;
	}
	public function bni_upload()
    {
		$data = file_get_contents('uploads/bank_bni.txt');
		$data = str_replace(" | ",";;",$data);
		$data = explode("\n",$data);
		//print_r($data);
		$nno_rek = explode("|", str_replace('-','',$data[3]));
		$no_rek = trim($nno_rek[1]); 
		$total = count($data) - 1;
		//$total = 8;
		$ttl = 0;
		for ($x = 5; $x <= $total; $x++) {
			
			  $row = explode('|',$data[$x]);
			  
			  if ($no_rek == '5601004280') {
				  //print_r($row);
				  $rtgl = explode("/",trim($row[0]));
				  $tanggal = substr($row[1],6,4).'-'.substr($row[1],3,2).'-'.substr($row[1],0,2);
				 $jam = substr($row[1],11,2).':'.substr($row[1],14,2).':'.substr($row[1],17,2);
				  $keterangan = trim(str_replace(';;',' | ',$row[4]));
				  $rnominal = trim($row[5]);
				 if (trim($row[6]) == 'C'){
					$debet = 0;
					$kredit = $rnominal;
				 }else{
					$debet = $rnominal;
					$kredit = 0;
				 }
						
					$saldo = trim($row[7]);
					$hash = md5($tanggal.$debet.$kredit.$keterangan.$saldo);
					$this->db->where('bank','bank_bni');
					$this->db->where('hash',$hash);
					$cnt = $this->db->get('tblmutasi')->num_rows();
					if (!$cnt){
						$res = array (	
										'bank' => 'bank_bni',
										'no_rek' => $no_rek,
										'hash' => $hash,
										'debet' => $debet,
										'kredit' => $kredit,
										'saldo' => $saldo,
										'keterangan' => $keterangan,
										'tgl' => $tanggal,
										'tgl2' => strtotime($tanggal.' '.$jam)-25200,
										'tanggal' =>time(),
										);
						if ($kredit <> ''){			
						$this->db->insert('tblmutasi',$res);
						$ttl++;
						}
					}
				}
		}
		return $ttl;
	}
	function bank_tools($page=1) {
		if($this->input->post('bank')){
			$this->bank_upload();
		}
		$this->load->helper('form');
		$this->db->select('a.*');	
		//$this->db->where('a.us_id',$us_id);	
		if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.debet', $this->input->get('cari'));
			$this->db->or_like('a.kredit', $this->input->get('cari'));
			$this->db->or_like('a.keterangan', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tgl2 BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.bank',$produk);	
				}	
				
		}else{
			
			$this->db->where("FROM_UNIXTIME(tgl2,'%Y-%m-%d %H:%i:%s') BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()");
		}		
		$total = $this->db->count_all_results('tblmutasi a');
        $start = pagination_start($page);
        if ($total) {
			$this->db->select('a.*');		
			if ($this->input->get('cari') OR $this->input->get('start') OR $this->input->get('end') OR $this->input->get('produk') OR $this->input->get('status')) {
			$start_date =  strtotime($this->input->get('start'));
			$end_date = strtotime($this->input->get('end'))+86400;
			$produk = $this->input->get('produk');
			$this->db->group_start();
			$this->db->like('a.debet', $this->input->get('cari'));
			$this->db->or_like('a.kredit', $this->input->get('cari'));
			$this->db->or_like('a.keterangan', $this->input->get('cari'));
			$this->db->group_end();
				if ($this->input->get('start') &&  $this->input->get('end')) {
					$this->db->where("tgl2 BETWEEN $start_date AND $end_date");
				}
				if ($this->input->get('produk')) {
					$this->db->where('a.bank',$produk);	
				}
			}else{
				$this->db->where("FROM_UNIXTIME(tgl2,'%Y-%m-%d %H:%i:%s') BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()");
			}
			if (@$this->input->get('act') == 'download') {
				$this->db->order_by('a.id', 'asc');
			}else{
				$this->db->order_by('a.id', 'desc');
			}
			if ($this->input->get('act') == 'download') {
				if ((@$end_date-@$start_date) > 2678400) {
					 redirect("administrasi/bank_tools?success=false&msg=".urlencode("Max 1 bulan")."");
				}elseif ((@$start_date) == 0) {
					redirect("administrasi/bank_tools?success=false&msg=".urlencode("Tanggal harus diisi")."");
					
				}
			}else{
				$this->db->limit(10, $start);
			}
            $trx = $this->db->get('tblmutasi a')->result();
			
        } else {
            $trx = array();
        }
		$exp_time = time() - 3600 * 2;
		$data['breadcumb'] = 'Bank Report';
		$data['periode'] = $this->input->get('start').' - '.$this->input->get('end');
		$data['start'] = $start;
		$data['total'] = $total;
		$data['results'] = $trx;
		$data['exp_time'] = $exp_time;
		$data['bank_bca'] = $this->db->query("select saldo,tanggal from orderkuo_db.rekap_server where rk_id='108'")->row();
		$data['bank_bri'] = $this->db->query("select saldo,tanggal from orderkuo_db.rekap_server where rk_id='111'")->row();
		$data['bank_mandiri'] = $this->db->query("select saldo,tanggal from orderkuo_db.rekap_server where rk_id='110'")->row();
		$data['bank_bni'] = $this->db->query("select saldo,tanggal from orderkuo_db.rekap_server where rk_id='109'")->row();
		
		
		if (@$this->input->get('act') == 'download') {
			$this->report_bank($trx,@$this->input->get('produk'));
		}else{
			$data['view'] = 'administrasi/bank_tools';
			$this->load->view('layout', $data);
		}
	}
	public function upload()
    {
		//$config["upload_path"] = APPPATH . "cache/";
		//$config["upload_path"] = APPPATH . "logs/";
		$config["upload_path"] = "./test/";
        $config["allowed_types"] = "*";
		$new_name = 'bri.txt';
		$config['file_name'] = $new_name;
        $config["overwrite"] = true;
        $config["max_size"] = 10000;
        $this->load->library("upload", $config);
        if( !$this->upload->do_upload("bri_file") ) 
        {
            $this->session->set_flashdata("error", $this->upload->display_errors());
            redirect("admin/bri");
        }
        else
        {
			$result = $this->upload->data();
			$this->parsing_data();
			//echo file_get_contents($result['full_path']);
			$this->session->set_flashdata("success", "Sukses.. Mutasi segera diproses...");
			redirect("admin/bri");
		}
      
    }
	function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}
 
	 function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim(($this->penyebut($nilai)));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		 return $hasil;
	 }
	private function report_trx($trx) {
		$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Laporan Transaksi '.$this->input->get('start').' - '.$this->input->get('end'));
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:H2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'Tanggal')
                                        ->setCellValue('B2', 'Kategori')
                                        ->setCellValue('C2', 'Provider')
                                        ->setCellValue('D2', 'Voucher')
                                        ->setCellValue('E2', 'No HP')
                                        ->setCellValue('F2', 'Harga Jual')
                                        ->setCellValue('G2', 'Harga Beli')
                                        ->setCellValue('H2', 'Harga Laba');
		
			$i = 3;
			$ttl_laba = 0;
			$ttl_hb = 0;
			$ttl_hj = 0;
			foreach ( $trx as $row) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', format_tanggal($row->tr_tanggal))
				->setCellValue('B'.$i.'', $row->op_produk)
				->setCellValue('C'.$i.'', $row->op_nama)
				->setCellValue('D'.$i.'', $row->vo_nominal)
				->setCellValue('E'.$i.'', $row->tr_id_plgn ? $row->tr_id_plgn : $row->tr_no_hp)
				->setCellValue('F'.$i.'', ($row->tr_status == 'sukses' ? format_uang2($row->tr_harga) : "0"))
				->setCellValue('G'.$i.'', format_uang2($row->tr_harga-($row->tr_income/2)))
				->setCellValue('H'.$i.'',  ($row->tr_status == 'sukses' ? format_uang2($row->tr_income/2) : "0"));
				if ($row->tr_status == 'sukses'){
					$ttl_laba = $ttl_laba+($row->tr_income/2);
					$ttl_hb = $ttl_hb+$row->tr_harga+($row->tr_income/2);
					$ttl_hj = $ttl_hj+$row->tr_harga;
				}
			$i++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':H'.$i.'')->getFont()->setBold(true);
			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('D'.$i.'', 'Total')
				->setCellValue('E'.$i.'', format_uang2($ttl_hj))
				->setCellValue('F'.$i.'', format_uang2($ttl_hb))
				->setCellValue('G'.$i.'', format_uang2($ttl_laba));
          
			 $objPHPExcel->getActiveSheet()->setTitle('Laporan_'.$this->input->get('start').' - '.$this->input->get('end').'');            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan_'.$this->input->get('start').' - '.$this->input->get('end').'.xlsx"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	private function report_bank($trx,$produk="") {
		$this->load->library("PHPExcel");

		   
            $objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue('A1', 'Laporan '.str_replace('_',' ',strtoupper($produk)).' '.$this->input->get('start').' - '.$this->input->get('end'));
			$letter = 'B';
			while ($letter !== 'N') {
				$objPHPExcel->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
			$letter++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A1:F2')->getFont()->setBold(true);
            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('A2', 'No Rekening')
                                        ->setCellValue('B2', 'Tanggal')
                                        ->setCellValue('C2', 'Keterangan')
                                        ->setCellValue('D2', 'Debit')
                                        ->setCellValue('E2', 'Kredit')
                                        ->setCellValue('F2', 'Saldo');
		
			$i = 3;
			$ttl_db = 0;
			$ttl_cr = 0;
			foreach ( $trx as $row) {
		

			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A'.$i.'', $row->no_rek)
				->setCellValue('B'.$i.'', substr(format_tanggal(strtotime($row->tgl)),0,10))
				->setCellValue('C'.$i.'', $row->keterangan)
				->setCellValue('D'.$i.'', format_uang2($row->debet))
				->setCellValue('E'.$i.'', format_uang2($row->kredit))
				->setCellValue('F'.$i.'',  format_uang2($row->saldo));
				
					$ttl_db = $ttl_db+$row->debet;
					$ttl_cr = $ttl_cr+$row->kredit;
				
			$i++;
			}
			$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':H'.$i.'')->getFont()->setBold(true);
			 $objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('C'.$i.'', 'Total')
				->setCellValue('D'.$i.'', format_uang2($ttl_db))
				->setCellValue('E'.$i.'', format_uang2($ttl_cr));
          
			 $objPHPExcel->getActiveSheet()->setTitle($produk);            
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan_'.$produk.'_'.$this->input->get('start').' - '.$this->input->get('end').'.xlsx"');
			header('Cache-Control: max-age=0');
			header('Cache-Control: max-age=1');
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
			header ('Cache-Control: cache, must-revalidate'); 
			header ('Pragma: public'); 

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			exit;
	 }
	
	
}

?>	